/*
 * $QNXLicenseC:
 * Copyright 2010, QNX Software Systems. All Rights Reserved.
 *
 * You must obtain a written license from and pay applicable
 * license fees to QNX Software Systems before you may reproduce,
 * modify or distribute this software, or any work that includes
 * all or part of this software.   Free development licenses are
 * available for evaluation and non-commercial purposes.  For more
 * information visit http://licensing.qnx.com or email
 * licensing@qnx.com.
 *
 * This file may contain contributions from others.  Please review
 * this entire file for other proprietary rights or license notices,
 * as well as the QNX Development Suite License Guide at
 * http://licensing.qnx.com/license-guide/ for other information.
 * $
 */

/*
 * Cypress control message header
 */

#ifndef UNITTEST
#include <sys/neutrino.h>
#else
#include "input_utest_header.h"
#include "ipc_header.h"
#include <limits.h>
#endif

#ifndef __CYPRESSMSG_H_INCLUDED
#define __CYPRESSMSG_H_INCLUDED

#define MAX_MFGID_SZ  0x10

/*
 * Cypress Commands
 */
typedef enum {
	CYPRESS_CTRL_FIRMWARE_UPGRADE,
	CYPRESS_CTRL_LASTXY_DATA,
	CYPRESS_CTRL_RESET,
	CYPRESS_CTRL_IDAC_CALIBRATION_REQUIRED,
	CYPRESS_CTRL_KEYPAD_APP_EVENT_REG,
	CYPRESS_CTRL_BUTTON_STATUS_REQUEST,
	CYPRESS_CTRL_CONTROLLER_INFO_REQUEST,
	CYPRESS_CTRL_DESIGN_SIZE_REQUEST,
	CYPRESS_CTRL_DESIGN_DATA_REQUEST,
	CYPRESS_CTRL_MANUFACTURER_SIZE_REQUEST,
	CYPRESS_CTRL_MANUFACTURER_DATA_REQUEST,
	CYPRESS_CTRL_ADDTIONAL_CONTROLLER_INFO_REQUEST,
	CYPRESS_CTRL_IDAC_CALIBRATION_REQUEST,
	CYPRESS_CTRL_IDAC_DATA_SIZE_REQUEST,
	CYPRESS_CTRL_IDAC_DATA_REQUEST,
	CYPRESS_CTRL_NOISE_LEVEL_DATA_REQUEST,
	CYPRESS_CTRL_INIT_BASELINES,
	CYPRESS_CTRL_SAVE_CP_CM_DATA_TO_FILE,
	CYPRESS_CTRL_CONTROLLER_STATUS_REQUEST,
	CYPRESS_MODE_CHG_REQUEST
} cypress_msg_cmd_e;

typedef struct {
	unsigned x;
	unsigned y;
} point_t;

typedef union {
	char buf[PATH_MAX];
	uint8_t sensing_mode;
	point_t coordinates;
} data_t;

typedef struct {
	cypress_msg_cmd_e type;
	uint16_t  cmd;
	data_t data;
} cypress_msg_ctrl_t;

/*
 * Request last X/Y data from the controller
 */
typedef struct {
	cypress_msg_cmd_e type;
	void* buf;
	unsigned buflen;
} cypress_msg_xy_data_t;

/*
 * Request button status
 */
typedef struct {
	cypress_msg_cmd_e type;
	void* buf;
	unsigned buflen;
} cypress_msg_button_status_t;

/*
 * Controller Info
 */
typedef struct {
	cypress_msg_cmd_e type;
	uint8_t product_id;
	uint8_t firmware_ver_major;
	uint8_t firmware_ver_minor;
	uint16_t silicon_id;
	uint8_t date;
} cypress_msg_controller_info_t;

/*
 * Additional Controller Info
 */
typedef struct {
	cypress_msg_cmd_e type;
        uint64_t revctrl;                               /* Rev Control Number */
        uint8_t bl_ver_major;                           /* Major Version */
        uint8_t bl_ver_minor;                           /* Minor Version */
        uint8_t mfgid_sz;                               /* Manufacturing ID Size */
        uint8_t mfgid[MAX_MFGID_SZ];                    /* Manufacturing ID byte (array) */
        uint16_t cyito_ver;                             /* CYITO_VER */
        uint8_t ttsp_ver_major;                         /* TTSP major version */
        uint8_t ttsp_ver_minor;                         /* TTSP minor version*/
        uint8_t device_info;                            /* Endianness (bit 0) */
} cypress_msg_add_controller_info_t;


/*
 * Controller Status Request.
 * NOTE: This struct will expand later on
 */
typedef struct {
	cypress_msg_cmd_e type;
	int idac_calibration_status;
} cypress_msg_add_controller_status_t;

/*
 * Customer Data
 * Replies with the size (request first) and then the data from
 * the Design and Manufacturing section of the Cypress controllers system information.
 */
typedef struct {
	cypress_msg_cmd_e type;
	int size;
	uint8_t *data;
} cypress_msg_customer_data_t;

/*
 * Retrieve Data Structure
 * Replies with the size (request first) and then the data from
 * the controller.  Used for retrieving IDAC calibration information.
 */
typedef struct {
	cypress_msg_cmd_e type;
	int size;
	uint8_t *data;
} cypress_msg_retrieve_data_struct_t;

/*
 * register event
 * Register an event with Cypress driver.  The event will be returned to
 * original app when a button press has occured.  At that time the app should
 * call CYPRESS_CTRL_BUTTON_STATUS_REQUEST
 */
typedef struct {
	cypress_msg_cmd_e type;
	struct sigevent ev;
} cypress_msg_register_event_t;

/*
 * Retrieve Noise Level data from controller.
 */
typedef struct {
	cypress_msg_cmd_e type;
	uint16_t noise_level;
	uint16_t noise_level_velocity;
} cypress_msg_retrieve_noise_data_t;

/* Cypress mode change */
typedef struct {
	cypress_msg_cmd_e type;
	uint8_t mode;
} cypress_mode_chg_t;

typedef union {
	struct _pulse pulse;
	cypress_msg_cmd_e cmd;
	cypress_msg_ctrl_t ctrl;
	cypress_msg_xy_data_t xy_data;
	cypress_msg_button_status_t status;
	cypress_msg_register_event_t reg_event;
	cypress_msg_controller_info_t controller_info;
	cypress_msg_customer_data_t customer_data;
	cypress_msg_add_controller_info_t additional_controller_info;
	cypress_msg_retrieve_data_struct_t retrieve_data;
	cypress_msg_retrieve_noise_data_t noise_data;
	cypress_msg_add_controller_status_t controller_status;
	cypress_mode_chg_t mode_chg;
} cypress_msg_u;

#endif /* __CYPRESSMSG_H_INCLUDED */

#if defined(__QNXNTO__) && defined(__USESRCVERSION)
#include <sys/srcversion.h>
__SRCVERSION("$URL: http://svn.ott.qnx.com/product/branches/7.0.0/trunk/hardware/mtouch/public/hw/cypressctrl.h $ $Rev: 886397 $")
#endif
